(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     75243,       2516]
NotebookOptionsPosition[     69425,       2360]
NotebookOutlinePosition[     69804,       2376]
CellTagsIndexPosition[     69761,       2373]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Houghton-Cassegrain", "Title"],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["HoughtonCassegrain",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["ft",
           FontWeight->Bold], Cell["total focal length"]},
         {Cell["spes",
           FontWeight->Bold], Cell["list of thickness of the doublet"]},
         {Cell["em",
           FontWeight->Bold], Cell["back distance"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[Delta]",
           FontWeight->Bold], Cell["distance of doublet from mirror"]},
         {Cell["Ni",
           FontWeight->Bold], Cell["refractive index of the lens"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["CameraType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["\"SD\""], Cell[
          "Houghton's Cassegrain with symmetrix doublet"]},
         {"\[SpanFromAbove]", Cell["\"DDR\""], Cell["\<\
Houghton's Cassegrain with doublet with different radii - no control of \
astigmatism\
\>"]},
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["\"Report\""], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["\"Print\""], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["\"Basic\""], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["\"Values\""], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["\"Full\""], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["\"Minimal\""], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["HoughtonCassegrainInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analysis of Houghton-Cassegrain telescope design", "Title"],

Cell[TextData[{
 "The Houghton-Cassegrain telescope is formed by an afocal doublet ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " of two thin lenses of the same glass, having the task to eliminate \
spherical aberration and coma of the primary and secondary mirrors, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "2"], TraditionalForm]]],
 ", of a Cassegrain combination. Since ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " has no astigmatism, there is no possibility to control the astigmatism of  \
the Cassegrain scheme by the characteristics of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 ". Therefore, this aberration depends only on the distance \[Delta]",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " from ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    FormBox["S",
     TraditionalForm], "1"], TraditionalForm]]],
 ". \nWe recall that the Cassegrain project starts with the following data:"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"em", " ", "=", " ", 
    RowBox[{"back", " ", "distance"}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["f", "t"], " ", "=", " ", 
    RowBox[{
    "focal", " ", "length", " ", "of", " ", "Cassegrain", " ", 
     "combination"}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["f", "1"], " ", "=", " ", 
    RowBox[{"focal", " ", "length", " ", "of", " ", 
     SubscriptBox["S", "1"]}]}]}], TraditionalForm]], "DisplayFormula"],

Cell["Then the following nondimensional constants are evaluated", "Text",
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", " ", "=", " ", 
   FractionBox["em", 
    SubscriptBox["f", "1"]]}], ",", "\n", 
  RowBox[{"M", " ", "=", " ", 
   FractionBox[
    SubscriptBox["f", "t"], 
    SubscriptBox["f", "1"]]}], ",", "\n", 
  RowBox[{"\[Beta]", " ", "=", " ", 
   FractionBox[
    RowBox[{"M", "-", "\[Alpha]"}], 
    RowBox[{"M", "+", "1"}]]}], ",", "\n", 
  RowBox[{"\[Gamma]", " ", "=", " ", 
   FractionBox[
    RowBox[{"2", 
     RowBox[{"M", "(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
    RowBox[{"1", "-", 
     SuperscriptBox["M", "2"]}]]}]}]], "DisplayFormula"],

Cell["\<\
which allow us to determine the remaining characteristics of the Cassegrain \
scheme:\
\>", "Text",
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["s", "12"], " ", "=", " ", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", 
     SubscriptBox["f", "1"], " ", 
     RowBox[{"(", 
      RowBox[{"distance", " ", "between", " ", 
       SubscriptBox["S", "1"], " ", "and", " ", 
       SubscriptBox["S", "2"]}], ")"}]}]}], ",", "\n", 
   RowBox[{
    RowBox[{"\[Gamma]", " ", 
     SubscriptBox["f", "1"]}], " ", "=", " ", 
    RowBox[{"radius", " ", "of", " ", 
     SubscriptBox["S", "2"]}]}]}], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
 "As usual, when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", " "}], TraditionalForm]]],
 "is afocal, the total aberration coefficients are obtained adding the \
coefficients of the mirrors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "2"], TraditionalForm]]],
 ", taking into account that the aperture stop ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 " at a distance \[Delta]",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " from ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "1"], TraditionalForm]]],
 ", and the coefficients of the doublet located at ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 ". For spherical ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "2"], TraditionalForm]]],
 ", we have the following input data. (the variables f1, \[Beta], \[Gamma], \
M, \[Alpha], r, x, \[Theta], \[Lambda] have to be unassigned, for that we use \
Clear)"
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f1", ",", "\[Beta]", ",", "\[Gamma]", ",", "M", ",", "\[Alpha]", ",", "r",
     ",", "x", ",", "\[Theta]", ",", "\[Lambda]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", 
   FractionBox[
    RowBox[{"M", "-", "\[Alpha]"}], 
    RowBox[{"M", "+", "1"}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Gamma]", " ", "=", 
   FractionBox[
    RowBox[{"2", "M", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
    RowBox[{"1", "-", 
     SuperscriptBox["M", "2"]}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "f1"}], ",", " ", 
      RowBox[{"\[Gamma]", " ", "f1"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", "f1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TotalAberrations", "[", 
   RowBox[{
   "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "r", ",", "0", ",", 
    RowBox[{
     RowBox[{"-", "\[Delta]"}], " ", "f1"}], ",", 
    RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
    RowBox[{"{", "\[Lambda]", "}"}]}], "]"}], ";"}]], "Input"],

Cell[TextData[{
 "and the spherical aberration and coma coefficients of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "1"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "2"], TraditionalForm]]],
 " write:"
}], "Text"],

Cell[BoxData[
 RowBox[{"DS1", "=", 
  RowBox[{"GOSphericalCoefficient", "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"DS2", "=", 
  RowBox[{"GOComaCoefficient", "//", "Simplify"}]}]], "Input"],

Cell[TextData[{
 "To evaluate the aberrations of Hougthon's corrector ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 ", two possibilities can be analyzed."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
 "The two thin lenses of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " have curvature radii ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "/", 
     SubscriptBox["c", "1"]}], ",", " ", 
    RowBox[{"1", "/", 
     SubscriptBox["c", "2"]}], ",", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "/", 
     SubscriptBox["c", "1"]}], ",", " ", 
    RowBox[{"1", "/", 
     SubscriptBox["c", "2"]}]}], TraditionalForm]]],
 " (it is plain to verify that this system is afocal, when the thickness is \
zero);"
}], "ItemNumbered"],

Cell["the curvature radii are different and verify the condition", \
"ItemNumbered"]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["c", "1"], "-", 
    SubscriptBox["c", "2"], "+", 
    SubscriptBox["c", "3"], "-", 
    SubscriptBox["c", "4"]}], "=", "0"}], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
 "in order to have an afocal corrector ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 ".\nWith respect to the first possibility, the following system has to be \
considered:"
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "c1", ",", "c2", ",", "Ni", ",", "r", ",", "x", ",", "\[Theta]", ",", 
    "\[Lambda]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "c1"}], ",", 
      RowBox[{"1", "/", "c2"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "c1"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "c2"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Ni", ",", "1", ",", "Ni", ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "r", ",", "0", ",", 
   "0", ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]], "Input"],

Cell["\<\
Where spherical, coma and astigmatism coefficients are given by the following \
variables\
\>", "Text",
 CellChangeTimes->{{3.6778424430796413`*^9, 3.677842466939675*^9}}],

Cell[BoxData["GOSphericalCoefficient"], "Input"],

Cell[BoxData["GOComaCoefficient"], "Input"],

Cell[BoxData["GOAstigmatismCoefficient"], "Input"],

Cell[TextData[{
 "Spherical aberration and coma coefficients of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " write:"
}], "Text"],

Cell[BoxData[
 RowBox[{"DC1", " ", "=", " ", 
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Ni", "+", "1"}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"Ni", "-", "1"}], ")"}], "2"]}], 
      RowBox[{"4", "Ni"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["c", "1"], "-", 
        SubscriptBox["c", "2"]}], ")"}], "2"], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["c", "1"], "+", 
       SubscriptBox["c", "2"]}], ")"}]}], ","}],
   TraditionalForm]}]], "DisplayFormula"],

Cell[BoxData[
 RowBox[{"DC2", " ", "=", " ", 
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["Ni", "2"], "-", "1"}], 
      RowBox[{"2", "Ni"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["c", "1"], "2"], "-", 
       SuperscriptBox[
        SubscriptBox["c", "2"], "2"]}], ")"}], "."}]}],
   TraditionalForm]}]], "DisplayFormula"],

Cell[TextData[{
 "In Chapter 5 it is proved that the curvature radii ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["R", "1"], ",", " ", 
    SubscriptBox["R", "2"], ",", " ", 
    RowBox[{"-", 
     SubscriptBox["R", "1"]}], ",", " ", 
    RowBox[{"-", 
     SubscriptBox["R", "2"]}]}], TraditionalForm]]],
 " of the two lenses of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 ", which eliminate spherical aberration and coma"
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DS1", " ", "+", " ", "DC1"}], " ", "=", " ", "0"}], "\n", 
 RowBox[{
  RowBox[{"DS2", " ", "+", " ", "DC2"}], " ", "=", " ", 
  "0"}]}], "DisplayFormula"],

Cell["satisfy an equivalent first degree system", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["c", "1"], "-", 
   SubscriptBox["c", "2"]}], "=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", "DS1"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Ni", "-", "1"}], ")"}], "DS2"}]]}]}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["c", "1"], "+", 
   SubscriptBox["c", "2"]}], "=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Ni", " ", 
     SuperscriptBox["DS2", "2"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Ni", "+", "1"}], ")"}], "DS1"}]]}]}]}], "DisplayFormula"],

Cell[TextData[{
 "whose solutions, in terms of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "2"], TraditionalForm]]],
 ", are"
}], "Text"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   SubscriptBox["R", "1"], "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "DS1", " ", "DS2"}], 
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["DS1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"Ni", "+", "1"}], ")"}]}], " ", "+", " ", 
      RowBox[{
       SuperscriptBox["DS2", "3"], " ", 
       RowBox[{"Ni", "(", 
        RowBox[{"Ni", "-", "1"}], ")"}]}]}]]}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   SubscriptBox["R", "2"], "=", 
   FractionBox[
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "DS1", " ", "DS2"}], 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["DS1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"Ni", "+", "1"}], ")"}]}], " ", "-", " ", 
     RowBox[{
      SuperscriptBox["DS2", "3"], " ", 
      RowBox[{"Ni", "(", 
       RowBox[{"Ni", "-", "1"}], ")"}]}]}]]}], 
  TraditionalForm]}], "DisplayFormulaNumbered"],

Cell["\<\
When expressions  relative to DS1 and DS2 are taken into account, the \
following relations are derived:\
\>", "Text"],

Cell[BoxData[
 RowBox[{"R1", "=", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "DS1", " ", "DS2"}], 
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["DS1", "2"], 
       RowBox[{"(", 
        RowBox[{"Ni", "+", "1"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["DS2", "3"], "Ni", 
       RowBox[{"(", 
        RowBox[{"Ni", "-", "1"}], ")"}]}]}]]}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"R2", "=", 
  RowBox[{
   FractionBox[
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "DS1", " ", "DS2"}], 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["DS1", "2"], 
      RowBox[{"(", 
       RowBox[{"Ni", "+", "1"}], ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["DS2", "3"], "Ni", 
      RowBox[{"(", 
       RowBox[{"Ni", "-", "1"}], ")"}]}]}]], "//", "Simplify"}]}]], "Input"],

Cell[TextData[{
 "In order to understand the behavior of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "2"], TraditionalForm]]],
 " with respect to \[Delta], the plots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "1"], "=", 
    RowBox[{
     SubscriptBox["R", "1"], "/", 
     SubscriptBox["f", "1"]}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "2"], "="}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["R", "2"], "/", 
    SubscriptBox["f", "1"]}], TraditionalForm]]],
 " versus \[Delta] is considered for BK7 (Ni = 1.5187228), ",
 Cell[BoxData[
  FormBox[
   RowBox[{"M", "=", "3"}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"M", "=", "4"}], TraditionalForm]]],
 "  (the blue line refers to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]]],
 "):"
}], "Text"],

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{"-", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "f1"], 
      FractionBox[
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "DS1", " ", "DS2"}], 
       RowBox[{
        RowBox[{"2", 
         SuperscriptBox["DS1", "2"], 
         RowBox[{"(", 
          RowBox[{"Ni", "+", "1"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["DS2", "3"], "Ni", 
         RowBox[{"(", 
          RowBox[{"Ni", "-", "1"}], ")"}]}]}]]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Alpha]", "\[Rule]", "0.3"}], ",", 
       RowBox[{"Ni", "->", "1.5187228"}], ",", 
       RowBox[{"M", "\[Rule]", "3"}]}], "}"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "f1"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "DS1", " ", "DS2"}], 
      RowBox[{
       RowBox[{"2", 
        SuperscriptBox["DS1", "2"], 
        RowBox[{"(", 
         RowBox[{"Ni", "+", "1"}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["DS2", "3"], "Ni", 
        RowBox[{"(", 
         RowBox[{"Ni", "-", "1"}], ")"}]}]}]]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Rule]", "0.3"}], ",", 
      RowBox[{"Ni", "->", "1.5187228"}], ",", 
      RowBox[{"M", "\[Rule]", "3"}]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r1", ",", "r2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", "0.7", ",", "1.5"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", " ", "Blue"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Delta]\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \
\(2\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{"-", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "f1"], 
      FractionBox[
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "DS1", " ", "DS2"}], 
       RowBox[{
        RowBox[{"2", 
         SuperscriptBox["DS1", "2"], 
         RowBox[{"(", 
          RowBox[{"Ni", "+", "1"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["DS2", "3"], "Ni", 
         RowBox[{"(", 
          RowBox[{"Ni", "-", "1"}], ")"}]}]}]]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Alpha]", "\[Rule]", "0.3"}], ",", 
       RowBox[{"Ni", "->", "1.5187228"}], ",", 
       RowBox[{"M", "\[Rule]", "4"}]}], "}"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "f1"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "DS1", " ", "DS2"}], 
      RowBox[{
       RowBox[{"2", 
        SuperscriptBox["DS1", "2"], 
        RowBox[{"(", 
         RowBox[{"Ni", "+", "1"}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["DS2", "3"], "Ni", 
        RowBox[{"(", 
         RowBox[{"Ni", "-", "1"}], ")"}]}]}]]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Rule]", "0.3"}], ",", 
      RowBox[{"Ni", "->", "1.5187228"}], ",", 
      RowBox[{"M", "\[Rule]", "4"}]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r1", ",", "r2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", "0.7", ",", "1.5"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Delta]\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \
\(2\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}]}], "]"}]], "Input"],

Cell[TextData[{
 "The above plots show that the best values of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]]],
 ", i. e. the greatest absolute values which reduce higher order aberrations, \
are obtained for \[Delta] \[Epsilon] [0.7, 1]. Moreover, to obtain a lower \
obstruction, we must increase the magnification ",
 Cell[BoxData[
  FormBox["M", TraditionalForm]]],
 ".\nAs a consequence, the radii ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]]],
 " reduce and the higher-order aberrations increase. These results are valid \
provided that the thickness of lenses can be neglected."
}], "Text",
 FontSize->18],

Cell["\<\
If the curvature radii are different, the following system has to be \
considered:\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "c1", ",", "c2", ",", "c3", ",", "Ni", ",", "r", ",", "x", ",", "\[Theta]",
     ",", "\[Lambda]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "c1"}], ",", 
      RowBox[{"1", "/", "c2"}], ",", 
      RowBox[{"1", "/", "c3"}], ",", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"c1", "-", "c2", "+", "c3"}], ")"}]}]}], "}"}]}], ";"}], 
  " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Ni", ",", "1", ",", "Ni", ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"TotalAberrations", "[", 
   RowBox[{
   "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "r", ",", "0", ",", 
    "0", ",", 
    RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
    RowBox[{"{", "\[Lambda]", "}"}]}], "]"}], ";"}]}], "Input"],

Cell[BoxData["GOSphericalCoefficient"], "Input"],

Cell[BoxData["GOComaCoefficient"], "Input"],

Cell[BoxData["GOAstigmatismCoefficient"], "Input"],

Cell[BoxData[
 RowBox[{"DC1", "=", 
  RowBox[{"Simplify", "[", "GOSphericalCoefficient", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"DC2", "=", 
  RowBox[{"Simplify", "[", "GOComaCoefficient", "]"}]}]], "Input"],

Cell["\<\
To put DC1 in a more convenient form, we note that the factor\
\>", "Text",
 FontSize->18],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", "Ni"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "Ni"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "c3"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "Ni"}], ")"}]}], "-", 
      RowBox[{"2", " ", "c2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["Ni", "2"]}], ")"}]}], "+", 
      RowBox[{"c1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "-", "Ni", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["Ni", "2"]}]}], ")"}]}]}], ")"}]}], 
   ")"}]}]], "DisplayFormula"],

Cell["becomes", "Text",
 FontSize->18],

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"8", " ", "Ni"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "Ni"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "c3"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "Ni"}], ")"}]}], "-", 
         RowBox[{"2", " ", "c2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["Ni", "2"]}], ")"}]}], "+", 
         RowBox[{"c1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "-", "Ni", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["Ni", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], 
    "]"}], "]"}], "]"}]], "Input"],

Cell[TextData[{
 "Spherical aberration and coma coefficients of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " write:"
}], "Text"],

Cell[BoxData[{
 RowBox[{"D1C", " ", "=", " ", 
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["c", "2"], "-", 
      SubscriptBox["c", "3"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["c", "1"], "-", 
      SubscriptBox["c", "2"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{"Ni", "+", "1"}], ")"}], "8"]}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", 
          SubscriptBox["c", "1"]}], "-", 
         RowBox[{"2", 
          SubscriptBox["c", "2"]}], "+", 
         SubscriptBox["c", "3"]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"4", "Ni"}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", 
          SubscriptBox["c", "1"]}], "-", 
         SubscriptBox["c", "2"], "+", 
         SubscriptBox["c", "3"]}], ")"}]}], "+", 
      RowBox[{
       FractionBox[
        SuperscriptBox["Ni", "2"], "4"], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["c", "1"], "-", 
         SubscriptBox["c", "2"]}], ")"}]}]}], ")"}]}],
   TraditionalForm]}], "\n", 
 RowBox[{"D2C", " ", "=", " ", 
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["Ni", "2"], "-", "1"}], 
      RowBox[{"2", "Ni"}]]}], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["c", "1"], "-", 
      SubscriptBox["c", "2"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["c", "2"], "-", 
      SubscriptBox["c", "3"]}], ")"}]}],
   TraditionalForm]}]}], "DisplayFormula"],

Cell["The curvature radii", "Text",
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["R", "1"], "=", 
    FractionBox["1", 
     SubscriptBox["c", "1"]]}], ",", " ", "\[IndentingNewLine]", 
   RowBox[{
    SubscriptBox["R", "2"], "=", 
    FractionBox["1", 
     SubscriptBox["c", "2"]]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    SubscriptBox["R", "3"], "=", 
    FractionBox["1", 
     SubscriptBox["c", "3"]]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    SubscriptBox["R", "4"], "=", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["c", "1"], "-", 
        SubscriptBox["c", "2"], "+", 
        SubscriptBox["c", "3"]}], ")"}], " "}]]}]}], 
  TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
 "of the two lenses of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 ", which eliminate spherical aberration and coma verify the system"
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"D1S", " ", "+", " ", "D1C"}], " ", "=", " ", "0"}], "\n", 
 RowBox[{
  RowBox[{"D2S", " ", "+", " ", "D2C"}], " ", "=", " ", 
  "0"}]}], "DisplayFormula"],

Cell["\<\
In the book it is proved that this system is equivalent to the following \
second degree system\
\>", "Text",
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], "x"}], "+", 
     RowBox[{
      SubscriptBox["a", "2"], "y"}]}], "=", 
    SubscriptBox["d", "1"]}], ",", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"y", "-", "1"}], ")"}]}], "=", 
    SubscriptBox["d", "2"]}], ","}], TraditionalForm]], "DisplayFormula"],

Cell["where", "Text",
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{
    FractionBox[
     SubscriptBox["c", "1"], 
     SubscriptBox["c", "3"]], "=", 
    FractionBox[
     SubscriptBox["R", "3"], 
     SubscriptBox["R", "1"]]}]}], ",", "\[IndentingNewLine]", 
  RowBox[{"y", "=", 
   RowBox[{
    FractionBox[
     SubscriptBox["c", "2"], 
     SubscriptBox["c", "3"]], "=", 
    FractionBox[
     SubscriptBox["R", "3"], 
     SubscriptBox["R", "2"]], " "}]}]}]], "DisplayFormulaNumbered"],

Cell["and", "Text",
 FontSize->18],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["a", "1"], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"8", "Ni"}]], 
     RowBox[{"(", 
      RowBox[{"4", "-", 
       RowBox[{"3", "Ni"}], "-", 
       RowBox[{"3", 
        SuperscriptBox["Ni", "2"]}], "+", 
       RowBox[{"2", 
        SuperscriptBox["Ni", "3"]}]}], ")"}]}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["a", "2"], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", "Ni"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "Ni", "+", 
       SuperscriptBox["Ni", "2"], "-", 
       SuperscriptBox["Ni", "3"]}], ")"}]}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["d", "1"], "=", 
    RowBox[{
     FractionBox["1", "8"], "-", 
     FractionBox["1", 
      RowBox[{"4", "Ni"}]], "+", 
     FractionBox["Ni", "8"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], 
       SubscriptBox["R", "3"], "DS1"}], 
      RowBox[{"2", "Ni", " ", "DS2"}]]}]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   SubscriptBox["d", "2"], "=", 
   FractionBox[
    RowBox[{"2", 
     SuperscriptBox[
      SubscriptBox["NiR", "3"], "2"], "DS2"}], 
    RowBox[{
     SuperscriptBox["Ni", "2"], "-", "1"}]]}], 
  TraditionalForm]}], "DisplayFormulaNumbered"],

Cell["The solutions of the above system write:", "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"a1", ",", "a2", ",", "d1", ",", "d2", ",", "x", ",", "y"}], "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"a1", " ", "x"}], "+", 
     RowBox[{"a2", " ", "y"}]}], "\[Equal]", "d1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"y", "-", "1"}], ")"}]}], "\[Equal]", "d2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", "Simplify"}]}], "Input"],

Cell["\<\
Finally, from the formula (2) and introducing the nondimensional radii\
\>", "Text",
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "1"], "=", 
    FractionBox[
     SubscriptBox["R", "1"], "f"]}], ",", "\[IndentingNewLine]", " ", 
   RowBox[{
    SubscriptBox["r", "2"], "=", 
    FractionBox[
     SubscriptBox["R", "2"], "f"]}], ",", "\[IndentingNewLine]", " ", 
   RowBox[{
    SubscriptBox["r", "3"], "=", 
    FractionBox[
     SubscriptBox["R", "3"], "f"]}], ",", "\[IndentingNewLine]", " ", 
   RowBox[{
    SubscriptBox["r", "4"], "=", 
    FractionBox[
     SubscriptBox["R", "4"], "f"]}], ","}], 
  TraditionalForm]], "DisplayFormula"],

Cell["the following two solutions are obtained:", "Text",
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "1"], "=", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["r", "3"]}], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "2"], "-", 
         RowBox[{"2", 
          SubscriptBox["d", "1"]}]}], ")"}], "+", 
       RowBox[{
        SubscriptBox["a", "2"], "(", 
        RowBox[{
         SubscriptBox["a", "2"], "-", 
         SubscriptBox["d", "1"], "+", 
         SqrtBox["\[CapitalDelta]"]}], ")"}]}]]}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["r", "2"], "=", "    ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"], "+", 
       SubscriptBox["d", "1"], "+", 
       SqrtBox["\[CapitalDelta]"]}]]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   SubscriptBox["r", "1"], "=", " ", 
   RowBox[{
    SubscriptBox["r", "3"], 
    FractionBox[
     RowBox[{"2", 
      RowBox[{
       SubscriptBox["a", "1"], "(", 
       RowBox[{
        SubscriptBox["a", "1"], "+", 
        SubscriptBox["a", "2"]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "2"], "-", 
         RowBox[{"2", 
          SubscriptBox["d", "1"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["a", "2"], "(", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["a", "2"]}], "+", 
        SubscriptBox["d", "1"], "+", 
        SqrtBox["\[CapitalDelta]"]}], ")"}]}]]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "2"], "=", " ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"], "+", 
       SubscriptBox["d", "1"], "-", 
       SqrtBox["\[CapitalDelta]"]}]]}]}], ","}], 
  TraditionalForm]}], "DisplayFormulaNumbered"],

Cell["where", "Text",
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalDelta]", " ", "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"], "+", 
       SubscriptBox["d", "1"]}], ")"}], "2"], "-", 
    RowBox[{"4", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"]}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["d", "1"], "+", 
       RowBox[{
        SubscriptBox["a", "1"], 
        SubscriptBox["d", "2"]}]}], ")"}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered"],

Cell[TextData[{
 "These solutions are real if \[CapitalDelta]",
 Cell[BoxData[
  FormBox[
   RowBox[{">", "0"}], TraditionalForm]]],
 ". Owing to (3), the radii (4)-(5) and \[CapitalDelta], are functions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "3"], "  ", "and", "  ", Cell["\[Delta]."]}], 
   TraditionalForm]]],
 "To find the region of the plane ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["r", "3"], ",", " ", "\[Delta]"}], ")"}], TraditionalForm]]],
 " in which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalDelta]", ">", "0"}], TraditionalForm]]],
 ", for the glass BK7 (Ni = 1.5187228, in green light), it is sufficient to \
use Wolfram Language function RegionPlot"
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sost", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a1", "->", 
       FractionBox[
        RowBox[{"4", "-", 
         RowBox[{"3", " ", "Ni"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["Ni", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["Ni", "3"]}]}], 
        RowBox[{"8", " ", "Ni"}]]}], ",", 
      RowBox[{"a2", "->", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", "Ni", "+", 
         SuperscriptBox["Ni", "2"], "-", 
         SuperscriptBox["Ni", "3"]}], 
        RowBox[{"4", " ", "Ni"}]]}], ",", 
      RowBox[{"d1", "->", 
       RowBox[{
        FractionBox["1", "8"], "-", 
        FractionBox["1", 
         RowBox[{"4", " ", "Ni"}]], "+", 
        FractionBox["Ni", "8"], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "f1", " ", "r3", 
          " ", "DS1"}], 
         RowBox[{"2", " ", "Ni", " ", "DS2"}]]}]}], ",", 
      RowBox[{"d2", "->", 
       FractionBox[
        RowBox[{"2", "Ni", " ", 
         SuperscriptBox["r3", "2"], 
         SuperscriptBox["f1", "2"], "DS2"}], 
        RowBox[{
         SuperscriptBox["Ni", "2"], "-", "1"}]]}]}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Rule]", "0.4"}], ",", 
      RowBox[{"Ni", "->", "1.5187228"}], ",", 
      RowBox[{"M", "\[Rule]", "4"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a1", "+", "a2", "+", "d1"}], ")"}], "2"], "-", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"a1", "+", "a2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"d1", "+", 
         RowBox[{"a1", " ", "d2"}]}], ")"}]}]}], ")"}], "/.", "sost"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"\[CapitalDelta]", ">", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", "0.7", ",", "1.2"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.4"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(r\), \(3\)]\)\>\"", ",", "\"\<Text\>\""}], 
       "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<\[Delta]\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input"],

Cell[TextData[{
 "It is very important to recognize the behaviour of the radii (1)-(3) on \
varying ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "3"], TraditionalForm]]],
 " in the interval of its acceptable values for any fixed \[Delta].\nThe \
analysis of plots ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "1"], ",", " ", 
    SubscriptBox["r", "2"]}], TraditionalForm]]],
 " versus ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "3"], TraditionalForm]]],
 ", corresponding to both solutions, show that their more convenient values, \
for a fixed \[Delta], are obtained for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", "\[Element]", 
    RowBox[{"(", 
     RowBox[{"0.7", ",", "1.1"}], ")"}], " "}], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "3"], TraditionalForm]]],
 " coinciding with the lower bound of the interval determined by the \
intersection of the stright line \[Delta] = const with the region on the \
right hand side of the previous figure."
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r11", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "r3"}], 
      FractionBox[
       RowBox[{"2", " ", "a1", " ", 
        RowBox[{"(", 
         RowBox[{"a1", "+", "a2"}], ")"}]}], 
       RowBox[{
        RowBox[{"a1", " ", 
         RowBox[{"(", 
          RowBox[{"a2", "-", 
           RowBox[{"2", " ", "d1"}]}], ")"}]}], "+", 
        RowBox[{"a2", " ", 
         RowBox[{"(", 
          RowBox[{"a2", "-", "d1", "+", 
           SqrtBox["\[CapitalDelta]"]}], ")"}]}]}]]}], ")"}], "/.", 
    "sost"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r21", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r3", " ", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"a1", "+", "a2"}], ")"}]}], 
       RowBox[{"a1", "+", "a2", "+", "d1", "+", 
        SqrtBox["\[CapitalDelta]"]}]]}], ")"}], "/.", "sost"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r41", "=", 
   FractionBox[
    RowBox[{"r11", " ", "r21", " ", "r3"}], 
    RowBox[{
     RowBox[{"r21", " ", "r3"}], "-", 
     RowBox[{"r11", " ", "r3"}], "+", 
     RowBox[{"r11", " ", "r21"}]}]]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r11", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}], ",", 
     RowBox[{"r21", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}], ",", 
     RowBox[{"r41", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "2.68"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", "Blue", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[
FormBox[
SubscriptBox[\"r\", \"3\"], TraditionalForm]]]]]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \
\(2\)]\), \!\(\*SubscriptBox[\(r\), \(4\)]\)\>\""}], "}"}]}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r11", "/.", 
       RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}], ",", 
      RowBox[{"r21", "/.", 
       RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}], ",", 
      RowBox[{"r41", "/.", 
       RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r3", ",", 
      RowBox[{"-", "2.5"}], ",", 
      RowBox[{"-", "1.8"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Green", ",", "Blue", ",", "Red"}], "}"}]}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5"}], ",", "1"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[
FormBox[
SubscriptBox[\"r\", \"3\"], TraditionalForm]]]]]\)\>\"", ",", 
       "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \(2\
\)]\), \!\(\*SubscriptBox[\(r\), \(4\)]\)\>\""}], "}"}]}]}], "]"}], 
  "\n"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r12", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r3", 
      FractionBox[
       RowBox[{"2", " ", "a1", " ", 
        RowBox[{"(", 
         RowBox[{"a1", "+", "a2"}], ")"}]}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a1"}], " ", 
         RowBox[{"(", 
          RowBox[{"a2", "-", 
           RowBox[{"2", " ", "d1"}]}], ")"}]}], "+", 
        RowBox[{"a2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a2"}], "+", "d1", "+", 
           SqrtBox["\[CapitalDelta]"]}], ")"}]}]}]]}], ")"}], "/.", 
    "sost"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r22", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r3", " ", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"a1", "+", "a2"}], ")"}]}], 
       RowBox[{"a1", "+", "a2", "+", "d1", "-", 
        SqrtBox["\[CapitalDelta]"]}]]}], ")"}], "/.", "sost"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r42", "=", 
   FractionBox[
    RowBox[{"r12", " ", "r22", " ", "r3"}], 
    RowBox[{
     RowBox[{"r22", " ", "r3"}], "-", 
     RowBox[{"r12", " ", "r3"}], "+", 
     RowBox[{"r12", " ", "r22"}]}]]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r12", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}], ",", 
     RowBox[{"r22", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}], ",", 
     RowBox[{"r42", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", 
     RowBox[{"-", "1.34"}], ",", 
     RowBox[{"-", "1.2"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", "Blue", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "3.5"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[
FormBox[
SubscriptBox[\"r\", \"3\"], TraditionalForm]]]]]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \
\(2\)]\), \!\(\*SubscriptBox[\(r\), \(4\)]\)\>\""}], "}"}]}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r12", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}], ",", 
     RowBox[{"r22", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}], ",", 
     RowBox[{"r42", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1.5"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", "Blue", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[
FormBox[
SubscriptBox[\"r\", \"3\"], TraditionalForm]]]]]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \
\(2\)]\), \!\(\*SubscriptBox[\(r\), \(4\)]\)\>\""}], "}"}]}]}], 
  "]"}]], "Input"],

Cell[TextData[{
 "The above plots show that the best values of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "3"], TraditionalForm]]],
 ", i. e. the greatest absolute values which reduce higher-order aberrations, \
are given by the ",
 StyleBox["second",
  FontWeight->"Bold"],
 " solution and for \[Delta] \[Epsilon] [0.7, 0.9] . Moreover, to reduce the \
obstruction, we must increase the magnification ",
 Cell[BoxData[
  FormBox[
   RowBox[{"M", "."}], TraditionalForm]]],
 " As a consequence, the radii ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]]],
 " reduce and the higher-order aberrations increase. These results are valid \
provided that the thickness of lenses can be neglected. "
}], "Text",
 FontSize->18]
}, Open  ]],

Cell[CellGroupData[{

Cell["Houghton-Cassegrain summary of main functions", "Title"],

Cell["Houghton-Cassegrain with symmetric doublet", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["R", "1"], "=", 
   RowBox[{"f", 
    FractionBox[
     RowBox[{"4", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"2", "-", "\[Delta]"}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Ni", "+", "1"}], ")"}], "+", 
      RowBox[{"Ni", 
       RowBox[{"(", 
        RowBox[{"Ni", "-", "1"}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "-", "\[Delta]"}], ")"}], "3"]}]}]]}]}], ",", 
  "          ", "\n", 
  RowBox[{
   SubscriptBox["R", "2"], "=", 
   RowBox[{
    RowBox[{"-", "f"}], 
    FractionBox[
     RowBox[{"4", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"2", "-", "\[Delta]"}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Ni", "+", "1"}], ")"}], "-", 
      RowBox[{"Ni", 
       RowBox[{"(", 
        RowBox[{"Ni", "-", "1"}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "-", "\[Delta]"}], ")"}], "3"]}]}]]}]}], 
  ","}]], "DisplayFormula"],

Cell["\<\
\[Delta] \[Epsilon] [0.75, 1]. This is a good combination for speed less than \
F/3.5\
\>", "Text"],

Cell["Doublet with different radii (no control on astigmatism)", "Text"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "1"], "=", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["r", "3"]}], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "2"], "-", 
         RowBox[{"2", 
          SubscriptBox["d", "1"]}]}], ")"}], "+", 
       RowBox[{
        SubscriptBox["a", "2"], "(", 
        RowBox[{
         SubscriptBox["a", "2"], "-", 
         SubscriptBox["d", "1"], "+", 
         SqrtBox["\[CapitalDelta]"]}], ")"}]}]]}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["r", "2"], "=", "    ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"], "+", 
       SubscriptBox["d", "1"], "+", 
       SqrtBox["\[CapitalDelta]"]}]]}]}], ",", 
   "                                   ", "\n", 
   RowBox[{
    SubscriptBox["r", "1"], "=", " ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         SubscriptBox["a", "1"], "(", 
         RowBox[{
          SubscriptBox["a", "2"], "-", 
          RowBox[{"2", 
           SubscriptBox["d", "1"]}]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["a", "2"], "(", 
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["a", "2"]}], "+", 
         SubscriptBox["d", "1"], "+", 
         SqrtBox["\[CapitalDelta]"]}], ")"}]}]]}]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "2"], "=", " ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"], "+", 
       SubscriptBox["d", "1"], "-", 
       SqrtBox["\[CapitalDelta]"]}]]}]}], ",", 
   "                                         "}], 
  TraditionalForm]}], "DisplayFormula"],

Cell["where", "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalDelta]", " ", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["a", "1"], "+", 
        SubscriptBox["a", "2"], "+", 
        SubscriptBox["d", "1"]}], ")"}], "2"], "-", 
     RowBox[{"4", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["a", "1"], "+", 
        SubscriptBox["a", "2"]}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["d", "1"], "+", 
        RowBox[{
         SubscriptBox["a", "1"], 
         SubscriptBox["d", "2"]}]}], ")"}]}]}], ">", "0.", "        "}]}], 
  TraditionalForm]], "DisplayFormula"],

Cell["\<\
\[Delta] \[Epsilon] [0.8, 1.2]. This is a good combination for speed less \
than F/2.5\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["HoughtonCassegrain Examples", "Title"],

Cell["\<\
To use the HoughtonCassegrain function you can either use directly the \
function HoughtonCassegrain[f1, ft, spes, em, diam, \[Delta], Ni, \[Theta]] \
or use the interactive panel created by calling the function \
HoughtonCassegrainInputPanel[].
It let\[CloseCurlyQuote]s you to set input values and then call the \
HoughtonCassegrain function. Moreover, it helps to load examples from the \
saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Houghton Cassegrain 2800-200F/3.5", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "700"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ft", "=", "2800."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"15", ",", "1", ",", "5"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"em", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Delta]", "=", 
   RowBox[{"540", "/", "700"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.20"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"HoughtonCassegrain", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "spes", ",", "em", ",", "diam", ",", "\[Delta]", ",", 
   "Ni", ",", "\[Theta]"}], "]"}]], "Input"],

Cell["Houghton Cassegrain 2400-200F/3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "600"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ft", "=", "2400."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"15", ",", "5", ",", "5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Delta]", "=", 
   RowBox[{"480", "/", "600"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.27"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"HoughtonCassegrain", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "spes", ",", "em", ",", "diam", ",", "\[Delta]", ",", 
   "Ni", ",", "\[Theta]", ",", 
   RowBox[{"CameraType", "\[Rule]", "\"\<DDR\>\""}]}], "]"}]], "Input"],

Cell["Houghton Cassegrain 2000-200F/3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "450"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ft", "=", "2000."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"10", ",", "15", ",", "5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Delta]", "=", 
   RowBox[{"340", "/", "450"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.3"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"HoughtonCassegrain", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "spes", ",", "em", ",", "diam", ",", "\[Delta]", ",", 
   "Ni", ",", "\[Theta]", ",", 
   RowBox[{"CameraType", "\[Rule]", "\"\<DDR\>\""}]}], "]"}]], "Input"],

Cell["Houghton Cassegrain 2000-200F/2.25", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "450"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ft", "=", "2000."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"10", ",", "10", ",", "5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Delta]", "=", 
   RowBox[{"340", "/", "450"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.3"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"HoughtonCassegrain", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "spes", ",", "em", ",", "diam", ",", "\[Delta]", ",", 
   "Ni", ",", "\[Theta]", ",", 
   RowBox[{"CameraType", "\[Rule]", "\"\<DDR\>\""}]}], "]"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<HoughtonCassegrain\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"HoughtonCassegrain", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"HoughtonCassegrainInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1904, 992},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
TrackCellChangeTimes->False,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 36, 0, 71, "Title"],
Cell[CellGroupData[{
Cell[640, 26, 35, 0, 43, "Subsection"],
Cell[678, 28, 113, 2, 46, "Text"],
Cell[794, 32, 1780, 46, 387, "Text"],
Cell[2577, 80, 2538, 62, 519, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5152, 147, 40, 0, 43, "Subsection"],
Cell[5195, 149, 254, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5486, 160, 40, 0, 43, "Subsection"],
Cell[5529, 162, 111, 2, 46, "Text"],
Cell[5643, 166, 3193, 83, 551, "Text"],
Cell[8839, 251, 2296, 56, 473, "Text"],
Cell[11138, 309, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14652, 404, 65, 0, 71, "Title"],
Cell[14720, 406, 1096, 33, 94, "Text"],
Cell[15819, 441, 470, 13, 65, "DisplayFormula"],
Cell[16292, 456, 88, 1, 46, "Text"],
Cell[16383, 459, 603, 19, 166, "DisplayFormula"],
Cell[16989, 480, 124, 4, 46, "Text"],
Cell[17116, 486, 548, 16, 45, "DisplayFormula"],
Cell[17667, 504, 1085, 38, 70, "Text"],
Cell[18755, 544, 1225, 43, 201, "Input"],
Cell[19983, 589, 340, 8, 32, "Input"],
Cell[20326, 599, 250, 10, 46, "Text"],
Cell[20579, 611, 103, 2, 32, "Input"],
Cell[20685, 615, 98, 2, 32, "Input"],
Cell[20786, 619, 174, 5, 46, "Text"],
Cell[CellGroupData[{
Cell[20985, 628, 556, 19, 30, "ItemNumbered"],
Cell[21544, 649, 84, 1, 30, "ItemNumbered"]
}, Open  ]],
Cell[21643, 653, 227, 7, 24, "DisplayFormula"],
Cell[21873, 662, 209, 6, 70, "Text"],
Cell[22085, 670, 900, 30, 121, "Input"],
Cell[22988, 702, 268, 6, 32, "Input"],
Cell[23259, 710, 181, 4, 46, "Text"],
Cell[23443, 716, 48, 0, 32, "Input"],
Cell[23494, 718, 43, 0, 32, "Input"],
Cell[23540, 720, 50, 0, 32, "Input"],
Cell[23593, 722, 139, 5, 46, "Text"],
Cell[23735, 729, 607, 22, 46, "DisplayFormula"],
Cell[24345, 753, 432, 16, 46, "DisplayFormula"],
Cell[24780, 771, 458, 15, 46, "Text"],
Cell[25241, 788, 190, 5, 48, "DisplayFormula"],
Cell[25434, 795, 57, 0, 46, "Text"],
Cell[25494, 797, 540, 21, 91, "DisplayFormula"],
Cell[26037, 820, 226, 10, 46, "Text"],
Cell[26266, 832, 1089, 37, 123, "DisplayFormulaNumbered"],
Cell[27358, 871, 128, 3, 46, "Text"],
Cell[27489, 876, 508, 17, 56, "Input"],
Cell[28000, 895, 475, 16, 56, "Input"],
Cell[28478, 913, 1001, 40, 46, "Text"],
Cell[29482, 955, 791, 25, 56, "Input"],
Cell[30276, 982, 750, 24, 56, "Input"],
Cell[31029, 1008, 639, 19, 32, "Input"],
Cell[31671, 1029, 791, 25, 56, "Input"],
Cell[32465, 1056, 750, 24, 56, "Input"],
Cell[33218, 1082, 634, 19, 32, "Input"],
Cell[33855, 1103, 834, 25, 94, "Text"],
Cell[34692, 1130, 106, 3, 46, "Text"],
Cell[34801, 1135, 1212, 38, 143, "Input"],
Cell[36016, 1175, 48, 0, 32, "Input"],
Cell[36067, 1177, 43, 0, 32, "Input"],
Cell[36113, 1179, 50, 0, 32, "Input"],
Cell[36166, 1181, 107, 2, 32, "Input"],
Cell[36276, 1185, 102, 2, 32, "Input"],
Cell[36381, 1189, 100, 3, 46, "Text"],
Cell[36484, 1194, 730, 26, 43, "DisplayFormula"],
Cell[37217, 1222, 38, 1, 46, "Text"],
Cell[37258, 1225, 897, 29, 50, "Input"],
Cell[38158, 1256, 139, 5, 46, "Text"],
Cell[38300, 1263, 1613, 59, 91, "DisplayFormula"],
Cell[39916, 1324, 50, 1, 46, "Text"],
Cell[39969, 1327, 713, 24, 215, "DisplayFormula"],
Cell[40685, 1353, 172, 5, 46, "Text"],
Cell[40860, 1360, 190, 5, 48, "DisplayFormula"],
Cell[41053, 1367, 134, 4, 46, "Text"],
Cell[41190, 1373, 439, 16, 45, "DisplayFormula"],
Cell[41632, 1391, 36, 1, 46, "Text"],
Cell[41671, 1394, 480, 17, 87, "DisplayFormulaNumbered"],
Cell[42154, 1413, 34, 1, 46, "Text"],
Cell[42191, 1416, 1349, 48, 220, "DisplayFormulaNumbered"],
Cell[43543, 1466, 71, 1, 46, "Text"],
Cell[43617, 1469, 744, 25, 99, "Input"],
Cell[44364, 1496, 109, 3, 46, "Text"],
Cell[44476, 1501, 583, 19, 200, "DisplayFormula"],
Cell[45062, 1522, 72, 1, 46, "Text"],
Cell[45137, 1525, 1226, 43, 129, "DisplayFormulaNumbered"],
Cell[46366, 1570, 1265, 45, 129, "DisplayFormulaNumbered"],
Cell[47634, 1617, 36, 1, 46, "Text"],
Cell[47673, 1620, 602, 21, 27, "DisplayFormulaNumbered"],
Cell[48278, 1643, 762, 24, 74, "Text"],
Cell[49043, 1669, 1932, 61, 79, "Input"],
Cell[50978, 1732, 720, 21, 32, "Input"],
Cell[51701, 1755, 1051, 32, 102, "Text"],
Cell[52755, 1789, 1157, 39, 171, "Input"],
Cell[53915, 1830, 1015, 29, 35, "Input"],
Cell[54933, 1861, 1061, 30, 57, "Input"],
Cell[55997, 1893, 1187, 40, 171, "Input"],
Cell[57187, 1935, 1019, 29, 35, "Input"],
Cell[58209, 1966, 1014, 29, 35, "Input"],
Cell[59226, 1997, 997, 33, 74, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60260, 2035, 62, 0, 71, "Title"],
Cell[60325, 2037, 58, 0, 46, "Text"],
Cell[60386, 2039, 1159, 42, 97, "DisplayFormula"],
Cell[61548, 2083, 109, 3, 46, "Text"],
Cell[61660, 2088, 72, 0, 46, "Text"],
Cell[61735, 2090, 2542, 88, 261, "DisplayFormula"],
Cell[64280, 2180, 21, 0, 46, "Text"],
Cell[64304, 2182, 649, 22, 27, "DisplayFormula"],
Cell[64956, 2206, 110, 3, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65103, 2214, 44, 0, 71, "Title"],
Cell[65150, 2216, 479, 9, 94, "Text"],
Cell[65632, 2227, 49, 0, 46, "Text"],
Cell[65684, 2229, 576, 19, 187, "Input"],
Cell[66263, 2250, 185, 4, 32, "Input"],
Cell[66451, 2256, 47, 0, 46, "Text"],
Cell[66501, 2258, 559, 19, 187, "Input"],
Cell[67063, 2279, 244, 5, 32, "Input"],
Cell[67310, 2286, 47, 0, 46, "Text"],
Cell[67360, 2288, 559, 19, 187, "Input"],
Cell[67922, 2309, 244, 5, 32, "Input"],
Cell[68169, 2316, 50, 0, 46, "Text"],
Cell[68222, 2318, 559, 19, 187, "Input"],
Cell[68784, 2339, 244, 5, 32, "Input"],
Cell[69031, 2346, 65, 0, 46, "Text"],
Cell[69099, 2348, 89, 1, 32, "Input"],
Cell[69191, 2351, 66, 1, 32, "Input"],
Cell[69260, 2354, 70, 0, 46, "Text"],
Cell[69333, 2356, 76, 1, 32, "Input"]
}, Open  ]]
}
]
*)

